%% Analysis and plotting for .mat files from Sams Labview code V1.0
% Paul Gow

clear all
close all

files = ls('*.mat');  %saves list of files in current directory

%setting arrays to fill
thz_data = [];
T = [];
snr = [];
jjj = 1;    %increments for the for loop as some files wil be discarded


%% Running program
for ii = 1:size(files,1)
        src = load(files(ii,:));      %loads files one at a time
        discard = length(strfind(src.description,'[drop]'));
        if  discard == 0    %ingnores files comment [drop]
            T(jjj) = src.temperature;
            if (max(src.signal) + min(src.signal)) < 0.0
                snr(jjj) = min(src.signal);
            else
                snr(jjj) = max(src.signal);
            end
            jjj = jjj+1;
            
        end
        
        
end

% power = [10:10:150];    %setting power ranges measured
% 
% for ii = 1:length(power)
%     avg(ii)   = mean( snr(p==power(ii)) );  %finds mean of same powers
%     sdev(ii)   = std( snr(p==power(ii)) );  %finds standard deviation of same powers
%     n(ii)      = length(snr(p==power(ii))); %finds # of data points for each power
%     
% end
% 
% serr = sdev ./ sqrt(n); %calculates standard error for each power




%% Plotting
plot(T,snr*1e12,'.-');
xlabel('Temperature (K)');
ylabel('Peak-to-peak Current (pA)');
axis([0 300 0 150]); 
title('Au/Al DM-LPD emitter temperature characterisation');



